/*
 * Decompiled with CFR 0.152.
 */
package net.createmod.catnip.outliner;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.outliner.Outline;
import net.createmod.catnip.render.BindableTexture;
import net.createmod.catnip.render.PonderRenderTypes;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class BlockClusterOutline
extends Outline {
    private final Cluster cluster;
    protected final Vector3f pos0Temp = new Vector3f();
    protected final Vector3f pos1Temp = new Vector3f();
    protected final Vector3f pos2Temp = new Vector3f();
    protected final Vector3f pos3Temp = new Vector3f();
    protected final Vector3f normalTemp = new Vector3f();
    protected final Vector3f originTemp = new Vector3f();

    public BlockClusterOutline(Iterable<class_2338> positions) {
        this.cluster = new Cluster();
        positions.forEach(this.cluster::include);
    }

    @Override
    public void render(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt) {
        this.params.loadColor(this.colorTemp);
        Vector4f color = this.colorTemp;
        int lightmap = this.params.lightmap;
        boolean disableLineNormals = this.params.disableLineNormals;
        this.renderFaces(ms, buffer, camera, pt, color, lightmap);
        this.renderEdges(ms, buffer, camera, pt, color, lightmap, disableLineNormals);
    }

    protected void renderFaces(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt, Vector4f color, int lightmap) {
        BindableTexture faceTexture = this.params.faceTexture;
        if (faceTexture == null) {
            return;
        }
        if (this.cluster.isEmpty()) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)this.cluster.anchor.method_10263() - camera.field_1352, (double)this.cluster.anchor.method_10264() - camera.field_1351, (double)this.cluster.anchor.method_10260() - camera.field_1350);
        class_4587.class_4665 pose = ms.method_23760();
        class_1921 renderType = PonderRenderTypes.outlineTranslucent(faceTexture.getLocation(), true);
        class_4588 consumer = buffer.getLateBuffer(renderType);
        this.cluster.visibleFaces.forEach((face, axisDirection) -> {
            class_2350 direction = class_2350.method_10156((class_2350.class_2352)axisDirection, (class_2350.class_2351)face.axis);
            class_2338 pos = face.pos;
            if (axisDirection == class_2350.class_2352.field_11056) {
                pos = pos.method_10093(direction.method_10153());
            }
            this.bufferBlockFace(pose, consumer, pos, direction, color, lightmap);
        });
        ms.method_22909();
    }

    protected void renderEdges(class_4587 ms, SuperRenderTypeBuffer buffer, class_243 camera, float pt, Vector4f color, int lightmap, boolean disableNormals) {
        float lineWidth = this.params.getLineWidth();
        if (lineWidth == 0.0f) {
            return;
        }
        if (this.cluster.isEmpty()) {
            return;
        }
        ms.method_22903();
        ms.method_22904((double)this.cluster.anchor.method_10263() - camera.field_1352, (double)this.cluster.anchor.method_10264() - camera.field_1351, (double)this.cluster.anchor.method_10260() - camera.field_1350);
        class_4587.class_4665 pose = ms.method_23760();
        class_4588 consumer = buffer.getBuffer(PonderRenderTypes.outlineSolid());
        this.cluster.visibleEdges.forEach(edge -> {
            class_2338 pos = edge.pos;
            Vector3f origin = this.originTemp;
            origin.set((float)pos.method_10263(), (float)pos.method_10264(), (float)pos.method_10260());
            class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)edge.axis);
            this.bufferCuboidLine(pose, consumer, origin, direction, 1.0f, lineWidth, color, lightmap, disableNormals);
        });
        ms.method_22909();
    }

    public static void loadFaceData(class_2350 face, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3, Vector3f normal) {
        switch (face) {
            case field_11033: {
                pos0.set(0.0f, 0.0f, 1.0f);
                pos1.set(0.0f, 0.0f, 0.0f);
                pos2.set(1.0f, 0.0f, 0.0f);
                pos3.set(1.0f, 0.0f, 1.0f);
                normal.set(0.0f, -1.0f, 0.0f);
                break;
            }
            case field_11036: {
                pos0.set(0.0f, 1.0f, 0.0f);
                pos1.set(0.0f, 1.0f, 1.0f);
                pos2.set(1.0f, 1.0f, 1.0f);
                pos3.set(1.0f, 1.0f, 0.0f);
                normal.set(0.0f, 1.0f, 0.0f);
                break;
            }
            case field_11043: {
                pos0.set(1.0f, 1.0f, 0.0f);
                pos1.set(1.0f, 0.0f, 0.0f);
                pos2.set(0.0f, 0.0f, 0.0f);
                pos3.set(0.0f, 1.0f, 0.0f);
                normal.set(0.0f, 0.0f, -1.0f);
                break;
            }
            case field_11035: {
                pos0.set(0.0f, 1.0f, 1.0f);
                pos1.set(0.0f, 0.0f, 1.0f);
                pos2.set(1.0f, 0.0f, 1.0f);
                pos3.set(1.0f, 1.0f, 1.0f);
                normal.set(0.0f, 0.0f, 1.0f);
                break;
            }
            case field_11039: {
                pos0.set(0.0f, 1.0f, 0.0f);
                pos1.set(0.0f, 0.0f, 0.0f);
                pos2.set(0.0f, 0.0f, 1.0f);
                pos3.set(0.0f, 1.0f, 1.0f);
                normal.set(-1.0f, 0.0f, 0.0f);
                break;
            }
            case field_11034: {
                pos0.set(1.0f, 1.0f, 1.0f);
                pos1.set(1.0f, 0.0f, 1.0f);
                pos2.set(1.0f, 0.0f, 0.0f);
                pos3.set(1.0f, 1.0f, 0.0f);
                normal.set(1.0f, 0.0f, 0.0f);
            }
        }
    }

    public static void addPos(float x, float y, float z, Vector3f pos0, Vector3f pos1, Vector3f pos2, Vector3f pos3) {
        pos0.add(x, y, z);
        pos1.add(x, y, z);
        pos2.add(x, y, z);
        pos3.add(x, y, z);
    }

    protected void bufferBlockFace(class_4587.class_4665 pose, class_4588 consumer, class_2338 pos, class_2350 face, Vector4f color, int lightmap) {
        Vector3f pos0 = this.pos0Temp;
        Vector3f pos1 = this.pos1Temp;
        Vector3f pos2 = this.pos2Temp;
        Vector3f pos3 = this.pos3Temp;
        Vector3f normal = this.normalTemp;
        BlockClusterOutline.loadFaceData(face, pos0, pos1, pos2, pos3, normal);
        BlockClusterOutline.addPos((float)pos.method_10263() + (float)(face.method_10148() * 1) / 128.0f, (float)pos.method_10264() + (float)(face.method_10164() * 1) / 128.0f, (float)pos.method_10260() + (float)(face.method_10165() * 1) / 128.0f, pos0, pos1, pos2, pos3);
        this.bufferQuad(pose, consumer, pos0, pos1, pos2, pos3, color, lightmap, normal);
    }

    private static class Cluster {
        private class_2338 anchor;
        private Map<MergeEntry, class_2350.class_2352> visibleFaces;
        private Set<MergeEntry> visibleEdges = new HashSet<MergeEntry>();

        public Cluster() {
            this.visibleFaces = new HashMap<MergeEntry, class_2350.class_2352>();
        }

        public boolean isEmpty() {
            return this.anchor == null;
        }

        public void include(class_2338 pos) {
            if (this.anchor == null) {
                this.anchor = pos;
            }
            pos = pos.method_10059((class_2382)this.anchor);
            for (class_2350.class_2351 axis : Iterate.axes) {
                class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
                int[] nArray = Iterate.zeroAndOne;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int offset = nArray[i];
                    MergeEntry entry = new MergeEntry(axis, pos.method_10079(direction, offset));
                    if (this.visibleFaces.remove(entry) != null) continue;
                    this.visibleFaces.put(entry, offset == 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056);
                }
            }
            block2: for (class_2350.class_2351 axis : Iterate.axes) {
                for (class_2350.class_2351 axis2 : Iterate.axes) {
                    if (axis == axis2) continue;
                    for (class_2350.class_2351 axis3 : Iterate.axes) {
                        if (axis == axis3 || axis2 == axis3) continue;
                        class_2350 direction = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis2);
                        class_2350 direction2 = class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis3);
                        for (int offset : Iterate.zeroAndOne) {
                            class_2338 entryPos = pos.method_10079(direction, offset);
                            for (int offset2 : Iterate.zeroAndOne) {
                                MergeEntry entry = new MergeEntry(axis, entryPos = entryPos.method_10079(direction2, offset2));
                                if (this.visibleEdges.remove(entry)) continue;
                                this.visibleEdges.add(entry);
                            }
                        }
                    }
                    continue block2;
                }
            }
        }
    }

    private static class MergeEntry {
        private class_2350.class_2351 axis;
        private class_2338 pos;

        public MergeEntry(class_2350.class_2351 axis, class_2338 pos) {
            this.axis = axis;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof MergeEntry)) {
                return false;
            }
            MergeEntry other = (MergeEntry)o;
            return this.axis == other.axis && this.pos.equals((Object)other.pos);
        }

        public int hashCode() {
            return this.pos.hashCode() * 31 + this.axis.ordinal();
        }
    }
}

